/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

float4x4	g_environmentTransform;
float		g_currentTime;

#define		water_slope_dist	0.015f

float2		water_sectionPosition;
float3		water_terrainOffsetPosition;

float4		water_sunColour;
float3		water_sunDirection;
float3		water_sunSpecDirection;
float3		water_cameraPosition;


////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4	position	:	POSITION;
	float3	normal		:	NORMAL;
	float4	colour		:	COLOR;
	float2	uv1			:	TEXCOORD0;
};

struct VS_OUTPUT
{
	float4	position	:	POSITION;
	float2	uvPlane		:	TEXCOORD0;
	float2	uv1			:	TEXCOORD1;
	float2	uv2			:	TEXCOORD2;
	float2	uv3			:	TEXCOORD3;

	float3	posTex		:	TEXCOORD4;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT vs_water_3d_med( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	output.position = input.position;
	output.position.xz += water_sectionPosition;

	output.posTex = output.position;
	
	output.uvPlane = input.uv1;
	
	output.uv1 = (float2( output.position.x - water_terrainOffsetPosition.x, output.position.z - water_terrainOffsetPosition.z) / 102400.0f) + float2(g_currentTime * 0.000005f,0);
	output.uv2 = (float2( output.position.x - water_terrainOffsetPosition.x, output.position.z - water_terrainOffsetPosition.z) / 102400.0f) + float2(g_currentTime * -0.0000025f,0.333);
	output.uv3 = (float2( output.position.x - water_terrainOffsetPosition.x, output.position.z - water_terrainOffsetPosition.z) / 102400.0f) + float2(0.333,g_currentTime * 0.0000025f);

	output.position = mul(output.position, shader_transform_viewProj);

	return output;
}

/////////////////////////////////////////////////////////////////////////

sampler sampler_noise = sampler_state
{
	Texture = shader_texture_0;
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_water_height_map = sampler_state
{
	Texture = shader_texture_1;
	AddressU=Clamp;
	AddressV=Clamp;
	MipFilter = NONE; 
	MinFilter = LINEAR; 
	MagFilter = LINEAR;
};

sampler sampler_colour_cube = sampler_state 
{ 
	Texture = shader_texture_cubemap;
	AddressU = Wrap; 
	AddressV = Wrap; 
	MinFilter = LINEAR; 
	MagFilter = LINEAR;
};

/////////////////////////////////////////////////////////////////////////

float4 ps_water_3d_med( VS_OUTPUT input ) : COLOR
{
	float3 nSurfaceHeights;

	nSurfaceHeights.x = (tex2D(sampler_noise,input.uv1).rg + 
						tex2D(sampler_noise,input.uv2).rg + 
						tex2D(sampler_noise,input.uv1 * 5.0f).rg) * 0.333f;

	nSurfaceHeights.y = (tex2D(sampler_noise,input.uv1 + float2(water_slope_dist,0)).rg + 
						tex2D(sampler_noise,input.uv2 + float2(water_slope_dist,0)).rg + 
						tex2D(sampler_noise,input.uv1 * 5.0f + float2(water_slope_dist,0)).rg) * 0.333f;

	nSurfaceHeights.z = (tex2D(sampler_noise,input.uv1 + float2(0,water_slope_dist)).rg + 
						tex2D(sampler_noise,input.uv2 + float2(0,water_slope_dist)).rg + 
						tex2D(sampler_noise,input.uv1 * 5.0f + float2(0,water_slope_dist)).rg) * 0.333f;

	float3 nSurfaceNormal;
	nSurfaceNormal.y = 1.0f;
	nSurfaceNormal.x = (nSurfaceHeights.x - nSurfaceHeights.y) * 0.2f;
	nSurfaceNormal.z = (nSurfaceHeights.x - nSurfaceHeights.z) * 0.2f;


	// diffuse

	float nDiffuse = saturate(dot( nSurfaceNormal, -water_sunDirection ));
	

	// specular

	float3 vCamera = normalize(input.posTex-water_cameraPosition);
	float3 vHalfway = normalize(-water_sunSpecDirection - vCamera);
	float nSpecular = pow( abs( dot( nSurfaceNormal, vHalfway ) ), 1000.0f);


	// environment

	float3 nEnvColour = texCUBE(sampler_colour_cube,reflect( normalize(input.posTex-water_cameraPosition), nSurfaceNormal )).rgb;


	// water edge

	float nWaterHeight = tex2D(sampler_water_height_map, input.uvPlane).a;
	float nWaterTransp = saturate( (0.475f-nWaterHeight) * 5.0f );


	// final colour

	return float4(  (lerp(nDiffuse * float3(0.41,0.58,0.73), nEnvColour.rgb, 0.333) + nSpecular) * water_sunColour.rgb, nWaterTransp );
}

////////////////////////////////////////////////////////////

technique water_3d_med_11_20
{
	pass P0
	{
		AlphaBlendEnable = True;
		AlphaTestEnable = False;

		VertexShader = compile vs_1_1 vs_water_3d_med();	
		PixelShader = compile ps_2_0 ps_water_3d_med();	
	}
}

technique water_3d_med_11_00
{
	pass P0
	{
	}
}